/*
 * AmiVoice 2003 SDK
 *
 * Copyright (C) 2002-2013 Advanced Media, Inc. All Rights Reserved.
 */

/**
 * @file xcwrapper.h
 * ̃hLǵAXCWrapper Cu API dlłB
 */

#ifndef _XCWRAPPER_H_
#define _XCWRAPPER_H_

#if defined(_WIN32)
 #include <windows.h>
 #include <tchar.h>
#else
 #include <stdio.h>
 #include <stdlib.h>
 #include "tchar.h"
#endif

// =======================================================================
//  Helpers
// =======================================================================
// API GNX|[gC^tF[X
#if defined(_WIN32)
 #if defined(XCWRAPPER_EXPORTS) || defined(XCWRAPPER_NOEXPORTS)
  #define XCWRAPPER_API
 #else
  #define XCWRAPPER_API __declspec(dllimport)
 #endif
 #define XCWRAPPER_API_CALL __stdcall
#else
 #define XCWRAPPER_API
 #define XCWRAPPER_API_CALL
#endif

// =======================================================================
//  Constant definitions
// =======================================================================
/**
 * ԁB
 *
 * @see #AMI_RESULT
 * @see #AMI_RESULT_EVENT_CALLBACK
 */
enum AMI_RESULT_STATE {
  //! FXbhJnꂽB
  AMI_RESULT_STATE_THREAD_STARTED = 0,
  //! FXbhIꂽB
  AMI_RESULT_STATE_THREAD_ENDED = 1,
  //! ^JnꂽB
  AMI_RESULT_STATE_RESUMED = 2,
  //! ^~ꂽB
  AMI_RESULT_STATE_PAUSED = 3,
  //! ZO^ɂ蔭b̊JnoꂽB
  AMI_RESULT_STATE_UTTERANCE_STARTED = 4,
  //! ZO^ɂ蔭b̏IoꂽB
  AMI_RESULT_STATE_UTTERANCE_ENDED = 5,
  //! ZO^ɂ蔭bƌoꂽB
  AMI_RESULT_STATE_UTTERANCE_TOO_LONG = 6,
  //! ZO^ɂ艹傫ƌoꂽB
  AMI_RESULT_STATE_UTTERANCE_TOO_LOUD = 7,
  //! FJnꂽB
  AMI_RESULT_STATE_RESULT_CREATED = 8,
  //! FB
  AMI_RESULT_STATE_RESULT_UPDATED = 9,
  //! FAFʂeꂽB
  AMI_RESULT_STATE_RESULT_ACCEPTED = 10,
  //! FAFʂۂꂽB
  AMI_RESULT_STATE_RESULT_REJECTED = 11,
  //! [FT[o֘A] FT[oȂB
  AMI_SERVER_STATE_LOOKUP_ERROR = 12,
  //! [FT[o֘A] FT[oւ̐ڑɎsB
  AMI_SERVER_STATE_CONNECT_ERROR = 13,
  //! [FT[o֘A] ǗT[oFT[oɊւԂȂB
  AMI_SERVER_STATE_CONFIRM_ERROR = 14,
  //! [FT[o֘A] FT[oNCAg̑Ó̌؂ɎsB
  AMI_SERVER_STATE_VALIDATE_ERROR = 15,
  //! [FT[o֘A] FT[oւ̐ڑLZꂽB
  AMI_SERVER_STATE_CANCELLED_CONNECTING = 16,
  //! [FT[o֘A] FT[oւ̐ڑɐB
  AMI_SERVER_STATE_CONNECTED = 17,
  //! [FT[o֘A] f[^MɃG[B
  AMI_SERVER_STATE_SEND_ERROR = 18,
  //! [FT[o֘A] f[^MɃG[B
  AMI_SERVER_STATE_RECV_ERROR = 19,
  //! [FT[o֘A] FT[o狭IɃZbVN[YꂽB
  AMI_SERVER_STATE_DISCONNECTED_BY_FORCE = 20,
  /**
   * [FT[o֘A] FT[oT[oGMB
   *
   * FT[oMT[oǴAR[obN֐ŒʒmF (#AMI_RESULT) ̃oϐ result ʂĎ擾ł܂B
   * <p style="padding-left: 1em">
   *  <code>&quot;<font color="blue">%d1</font> <font color="blue">%d2</font> <font color="blue">%d3</font>&quot;</code>
   *  <table border="0" cellpadding="2" style="margin-left: 1em;">
   *  <tr><td valign="top"><nobr><code><font color="blue">%d1</font></code></nobr></td><td valign="top">F</td><td>g݉FGWɂF̏I҂ĂSẲf[^̒̉ԖڂɈʒu邩B</td></tr>
   *  <tr><td valign="top"><nobr><code><font color="blue">%d2</font></code></nobr></td><td valign="top">F</td><td>݉FGWɂF̏I҂Ă鉹f[^̐B</td></tr>
   *  <tr><td valign="top"><nobr><code><font color="blue">%d3</font></code></nobr></td><td valign="top">F</td><td>ݐڑ̃ZbV̐B</td></tr>
   * </table>
   * </p>
   */
  AMI_SERVER_STATE_SERVER_BUSY = 21,
};

/**
 * [h (Mode vpeB)B
 *
 * e[h̏ڍׂɂẮAXCWrapper Cu⑫hLgQƂĂB
 *
 * @warning G[g[T̃T|[g𖳌ɂԂŃrhꂽCu (amiGetInternalVersion() ֐Ԃo[W̕ "e" ܂܂ȂCu) ł̂ݗp邱Ƃł܂B
 *
 * @see amiSetMode()
 * @see amiGetMode()
 */
enum AMI_MODE {
  //! Fs܂B
  AMI_MODE_RECOGNITION = 1,
  //! FʏNCAgɑM܂B
  AMI_MODE_RESULT = 2,
  //! Fʏ̒Ɍ܂߂܂B
  AMI_MODE_ALTERNATIVE = 4,
  //! Fʏ̒ɐMx܂߂܂B
  AMI_MODE_CONFIDENCE = 8,
  //! Fʏ̒Ɋg^C^O܂߂܂B
  AMI_MODE_EXTENDED_TIME_TAG = 64,
  //! Fʏ̒ɃO}ɍv锭bp^[ō\ɂ^Og͏ƂĊ܂߂܂B
  AMI_MODE_EXTENDED_INTERPRETED = 512,
  //! Fʏ̒̊𐔎ɕϊ܂B
  AMI_MODE_TRANSLATED_WRITTEN_TEXT = 1024,
  //! Fʏ̒ɓǂݏ܂߂܂B
  AMI_MODE_EXTENDED_SPOKEN_FORM = 4096,
  //! FʏƂĊgFFʏNCAgɑM܂B
  AMI_MODE_EXTENDED_RESULT_DATA = 16384,
  //! FCxgɂԂFʏ̒ɐMx܂߂܂B
  AMI_MODE_CONFIDENCE_ON_UPDATED = 65536,
  //! FCxgɂԂFʏ̒Ɋg^C^O܂߂܂B
  AMI_MODE_EXTENDED_TIME_TAG_ON_UPDATED = 131072,
  //! FCxgɂԂFʏ̒Ƀ^O܂߂܂B
  AMI_MODE_TAGS_ON_UPDATED = 2097152,
};

/**
 * b؂o㉹f[^Ot@C܂͔b؂oOf[^Ot@C̏ỏ͎f[^` (AudioLogFormat vpeB)B
 *
 * @see amiSetAudioLogFormat()
 * @see amiGetAudioLogFormat()
 * @see amiSetRecordingAudioLogFormat()
 * @see amiGetRecordingAudioLogFormat()
 */
enum AMI_AUDIO_LOG_FORMAT {
  //! `̌`B
  AMI_AUDIO_LOG_FORMAT_UNKNOWN = -1,
  //! jA PCM MSB `B
  AMI_AUDIO_LOG_FORMAT_MSB = 0,
  //! jA PCM Wave `B
  AMI_AUDIO_LOG_FORMAT_WAVE = 1,
  //! Speex `B
  AMI_AUDIO_LOG_FORMAT_SPEEX = 2,
};

// =======================================================================
//  Type definitions
// =======================================================================
/**
 * FGW̃nhB
 */
typedef void* AMI_RECOGNIZER;

/**
 * R[obN֐ŒʒmFʁB
 */
typedef struct AmiResult {
  //! FʏԁB
  enum AMI_RESULT_STATE state;
  //! FʕB
  const TCHAR* result;
} AMI_RESULT;

/**
 * amiSetResultEvent() ֐Ŏgp郆[Uf[^B
 */
typedef void* AMI_RESULT_EVENT_USERDATA;

/**
 * amiSetResultEvent() ֐ŎgpR[obN֐B
 */
typedef void (XCWRAPPER_API_CALL *AMI_RESULT_EVENT_CALLBACK)(AMI_RESULT*, AMI_RESULT_EVENT_USERDATA);

// =======================================================================
//  Function definitions
// =======================================================================
#ifdef __cplusplus
extern "C" {
#endif
/**
 * XCWrapper Cu܂B
 *
 *  threading  true w肳ꂽꍇ́A
 * XCWrapper CuŔFpXbh쐬A
 * ̃XbhŔFs}`Xbh[hƂē삵܂B
 *
 *  threading  false w肳ꂽꍇ́A
 * AvP[V amiDecode() ֐K؂ȃ^C~OŌĂяoKv̂VOXbh[hƂē삵܂B
 *
 * @param threading }`Xbh[hɂ邩ǂB
 * @param tablePathName R[hϊe[ut@Ci[tH_BNULL w\B
 * @param logFileName Ot@CBNULL w\B
 *
 * @return FGW̃nhB
 *
 * @see amiTerminate()
 * @see amiDecode()
 */
XCWRAPPER_API AMI_RECOGNIZER XCWRAPPER_API_CALL amiInitialize(bool threading, const TCHAR* tablePathName, const TCHAR* logFileName);

/**
 * XCWrapper Cu܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @retval true XCWrapper CuɐB
 * @retval false XCWrapper CuɎsB
 *
 * @see amiInitialize()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiTerminate(AMI_RECOGNIZER recognizer);

/**
 * XCWrapper Cũo[WԂ܂B
 *
 * @return XCWrapper Cũo[W ("1.0.00" Ȃ)B
 */
XCWRAPPER_API const TCHAR* XCWRAPPER_API_CALL amiGetVersion();

/**
 * XCWrapper Cu̓o[WԂ܂B
 *
 * @return XCWrapper Cu̓o[W ("winnt_20070910" Ȃ)B
 */
XCWRAPPER_API const TCHAR* XCWRAPPER_API_CALL amiGetInternalVersion();

/**
 * GR[fBOԂ܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return GR[fBO ("MS932", "UTF-16", "UTF-8", "EUC_JP" Ȃ)B
 */
XCWRAPPER_API const TCHAR* XCWRAPPER_API_CALL amiGetEncoding(AMI_RECOGNIZER recognizer);

/**
 * R[obN֐ݒ肵܂B
 *
 * @param recognizer FGW̃nhB
 * @param callBack R[obN֐B
 * @param userData R[obN֐p[Uf[^B
 * @param oldCallBack ܂Őݒ肳ĂR[obN֐BNULL w\B
 * @param oldUserData ܂Őݒ肳ĂR[obN֐p[Uf[^BNULL w\B
 *
 * @retval true R[obN֐̃ZbgɐB
 * @retval false R[obN֐̃ZbgɎsB
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetResultEvent(AMI_RECOGNIZER recognizer,
														AMI_RESULT_EVENT_CALLBACK callBack,
														AMI_RESULT_EVENT_USERDATA userData,
														AMI_RESULT_EVENT_CALLBACK* oldCallBack,
														AMI_RESULT_EVENT_USERDATA* oldUserData);

/**
 * FGWAP[g܂B
 *
 * @param recognizer FGW̃nhB
 * @param recognizerFileName GW[h\[Xt@CB
 *
 * @retval true FGW̃AP[gɐB
 * @retval false FGW̃AP[gɎsB
 *
 * @see amiUnloadRecognizer()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiLoadRecognizer(AMI_RECOGNIZER recognizer, const TCHAR* recognizerFileName);

/**
 * FGWfAP[g܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @retval true FGW̃fAP[gɐB
 * @retval false FGW̃fAP[gɎsB
 *
 * @see amiLoadRecognizer()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiUnloadRecognizer(AMI_RECOGNIZER recognizer);

/**
 * FGWZbg܂B
 *
 * FGWňꎞIɊmۂĂ郏[N܂B
 * O}vt@CȂǑSẴvpeB̒l͕ێ܂B
 * āÃ\bȟĂяo̗Lȍ~̔Fʂɉe^邱Ƃ͂܂B
 *
 * ^܂͉FGWւ̉f[^̋ (amiIsActive()==true)A܂́A
 * F (amiIsRecognizing()==true) ̏Ԃɂ鎞́A
 * FGWZbg邱Ƃł܂ (߂lƂ false Ԃ܂) ̂ŁAӂĂB
 *
 * @param recognizer FGW̃nhB
 *
 * @retval true FGW̃ZbgɐB
 * @retval false FGW̃ZbgɎsB
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiResetRecognizer(AMI_RECOGNIZER recognizer);

/**
 * O}Qݒ肵܂B
 *
 * O}܂ǂݍ܂ĂȂꍇ̂݃O}ǂݍ݂܂B
 * ǂݍ܂ꂽO}́AIɗL܂B
 *
 * "-<font color="blue">&lt;GW[h&gt;</font>" ƂO}t@CƂĎw肷邱ƂŁA
 * ̃GW[hɊ܂܂ĂfBNe[VO}Lɂ邱Ƃł܂B
 *
 * @param recognizer FGW̃nhB
 * @param grammarFileNames O}t@CQB
 *                         ؂蕶 '|' gp邱Ƃŕ̃O}t@Cw\B
 *
 * @retval true O}Q̐ݒɐB
 * @retval false O}Q̐ݒɎsB
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetGrammars(AMI_RECOGNIZER recognizer, const TCHAR* grammarFileNames);

/**
 * LȃO}ǂݍ܂Ă邩ǂԂ܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @retval true LȃO}ǂݍ܂Ă鎞B
 * @retval false LȃO}ǂݍ܂ĂȂB
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiHasActiveGrammars(AMI_RECOGNIZER recognizer);

/**
 * SpeedVsAccuracy vpeB̒lݒ肵܂B
 *
 * SpeedVsAccuracy vpeB́A
 * FGWFsȂۂɁA
 * xƐx̂ǂǂ̒xD悵ĔFsȂ\܂B
 *
 * SpeedVsAccuracy vpeB̒l̎w\͈͂ 0.0`1.0 ŁA
 * 0.0 ɋ߂΋߂قǑxDƂȂA1.0 ɋ߂΋߂قǐxDƂȂ܂B<br>
 * SpeedVsAccuracy vpeB̏l 0.5 łA
 * amiLoadRecognizer() ֐ɂ艹FGWAP[gꂽ^C~O
 * SpeedVsAccuracy vpeB̒l͓ǂݍ܂ꂽFGWŗL̒lɕύX܂̂ŁAӂĂB
 *
 * @param recognizer FGW̃nhB
 * @param speedVsAccuracy ݒ肷 SpeedVsAccuracy vpeB̒lB0.0`1.0 ͈̔͂̒lw\B
 *
 * @retval true SpeedVsAccuracy vpeB̒l̐ݒɐB
 * @retval false SpeedVsAccuracy vpeB̒l̐ݒɎsB
 *
 * @see amiLoadRecognizer()
 * @see amiGetSpeedVsAccuracy()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetSpeedVsAccuracy(AMI_RECOGNIZER recognizer, float speedVsAccuracy);

/**
 * SpeedVsAccuracy vpeB̒l擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return SpeedVsAccuracy vpeB̒lB
 *
 * @see amiSetSpeedVsAccuracy()
 */
XCWRAPPER_API float XCWRAPPER_API_CALL amiGetSpeedVsAccuracy(AMI_RECOGNIZER recognizer);

/**
 * ConfidenceLevel vpeB̒lݒ肵܂B
 *
 * ConfidenceLevel vpeB́A
 * FGWF̔Fʂɋ߂ŒMx\܂B<br>
 * Fʂ̐Mx ConfidenceLevel vpeB̒lȏƂȂFʂ݂̂FƂăAvP[Vɒʒm܂B
 *
 * ConfidenceLevel vpeB̒l̎w\͈͂ 0.0`1.0 łB<br>
 * ConfidenceLevel vpeB̏l 0.0 łB
 *
 * @param recognizer FGW̃nhB
 * @param confidenceLevel ݒ肷 ConfidenceLevel vpeB̒lB0.0`1.0 ͈̔͂̒lw\B
 *
 * @retval true ConfidenceLevel vpeB̒l̐ݒɐB
 * @retval false ConfidenceLevel vpeB̒l̐ݒɎsB
 *
 * @see amiGetConfidenceLevel()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetConfidenceLevel(AMI_RECOGNIZER recognizer, float confidenceLevel);

/**
 * ConfidenceLevel vpeB̒l擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return ConfidenceLevel vpeB̒lB
 *
 * @see amiSetConfidenceLevel()
 */
XCWRAPPER_API float XCWRAPPER_API_CALL amiGetConfidenceLevel(AMI_RECOGNIZER recognizer);

/**
 * Mode vpeB̒lݒ肵܂B
 *
 * Mode vpeB́A
 * AvP[Vɂǂ̂悤ȔFʂʒm邩𐧌䂷邽߂̃[h\܂B
 *
 * Mode vpeB̏l 79 (#AMI_MODE_RECOGNITION (1) + #AMI_MODE_RESULT (2) + #AMI_MODE_ALTERNATIVE (4) + #AMI_MODE_CONFIDENCE (8) + #AMI_MODE_EXTENDED_TIME_TAG (64)) łB
 *
 * @param recognizer FGW̃nhB
 * @param mode ݒ肷 Mode vpeB̒lB
 * <table>
 *  <tr><td valign="top">#AMI_MODE_RECOGNITION (+1)</td>						<td>Fs܂B</td></tr>
 *  <tr><td valign="top">#AMI_MODE_RESULT (+2)</td>								<td>FʏNCAgɑM܂B</td></tr>
 *  <tr><td valign="top">#AMI_MODE_ALTERNATIVE (+4)</td>						<td>Fʏ̒Ɍ܂߂܂B</td></tr>
 *  <tr><td valign="top">#AMI_MODE_CONFIDENCE (+8)</td>							<td>Fʏ̒ɐMx܂߂܂B</td></tr>
 *  <tr><td valign="top">#AMI_MODE_EXTENDED_TIME_TAG (+64)</td>					<td>Fʏ̒Ɋg^C^O܂߂܂B</td></tr>
 *  <tr><td valign="top">#AMI_MODE_EXTENDED_INTERPRETED (+512)</td>				<td>Fʏ̒ɃO}ɍv锭bp^[ō\ɂ^Og͏ƂĊ܂߂܂B</td></tr>
 *  <tr><td valign="top">#AMI_MODE_TRANSLATED_WRITTEN_TEXT (+1024)</td>			<td>Fʏ̒̊𐔎ɕϊ܂B</td></tr>
 *  <tr><td valign="top">#AMI_MODE_EXTENDED_SPOKEN_FORM (+4096)</td>			<td>Fʏ̒ɓǂݏ܂߂܂B</td></tr>
 *  <tr><td valign="top">#AMI_MODE_EXTENDED_RESULT_DATA (+16384)</td>			<td>FʏƂĊgFFʏNCAgɑM܂B</td></tr>
 *  <tr><td valign="top">#AMI_MODE_CONFIDENCE_ON_UPDATED (+65536)</td>			<td>FCxgɂԂFʏ̒ɐMx܂߂܂B</td></tr>
 *  <tr><td valign="top">#AMI_MODE_EXTENDED_TIME_TAG_ON_UPDATED (+131072)</td>	<td>FCxgɂԂFʏ̒Ɋg^C^O܂߂܂B</td></tr>
 *  <tr><td valign="top">#AMI_MODE_TAGS_ON_UPDATED (+2097152)</td>				<td>FCxgɂԂFʏ̒Ƀ^O܂߂܂B</td></tr>
 * </table>
 *
 * @retval true Mode vpeB̒l̐ݒɐB
 * @retval false Mode vpeB̒l̐ݒɎsB
 *
 * @warning G[g[T̃T|[g𖳌ɂԂŃrhꂽCu (amiGetInternalVersion() ֐Ԃo[W̕ "e" ܂܂ȂCu) ł̂ݗp邱Ƃł܂B
 *
 * @see amiGetMode()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetMode(AMI_RECOGNIZER recognizer, int mode);

/**
 * Mode vpeB̒l擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return Mode vpeB̒lB
 *
 * @warning G[g[T̃T|[g𖳌ɂԂŃrhꂽCu (amiGetInternalVersion() ֐Ԃo[W̕ "e" ܂܂ȂCu) ł̂ݗp邱Ƃł܂B
 *
 * @see amiSetMode()
 */
XCWRAPPER_API int XCWRAPPER_API_CALL amiGetMode(AMI_RECOGNIZER recognizer);

/**
 * ResultUpdatedInterval vpeB̒lݒ肵܂B
 *
 * ResultUpdatedInterval vpeB́A
 * FCxg̔sԊu\܂B
 *
 * ResultUpdatedInterval vpeB̏l 1000 (1 b) łB
 *
 * @param recognizer FGW̃nhB
 * @param resultUpdatedInterval ݒ肷 ResultUpdatedInterval vpeB̒l (PʁF~b)B
 * <table>
 *  <tr>
 *   <td valign="top">0</td>
 *   <td>FCxg𔭍s܂B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">&gt;0</td>
 *   <td>w肳ꂽԂ̉f[^F閈ɔFCxg𔭍s܂B<br>
 *       FCxǵAۂɌo߂ԂɉĔŝł͂ȂAFꂽf[^̏ʂɉĔs܂B<br>
 *       100 ̒[܂ޒlw肳ꂽꍇ́A100 ̔{ɐ؂グlw肳ꂽ̂ƂĈ܂B</td>
 *  </tr>
 * </table>
 *
 * @retval true ResultUpdatedInterval vpeB̒l̐ݒɐB
 * @retval false ResultUpdatedInterval vpeB̒l̐ݒɎsB
 *
 * @see amiGetResultUpdatedInterval()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetResultUpdatedInterval(AMI_RECOGNIZER recognizer, int resultUpdatedInterval);

/**
 * ResultUpdatedInterval vpeB̒l擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return ResultUpdatedInterval vpeB̒l (PʁF~b)B
 *
 * @see amiSetResultUpdatedInterval()
 */
XCWRAPPER_API int XCWRAPPER_API_CALL amiGetResultUpdatedInterval(AMI_RECOGNIZER recognizer);

/**
 * AudioLogPathName vpeB̒lݒ肵܂B
 *
 * AudioLogPathName vpeB́A
 * b؂o㉹f[^Ot@C̏o͐tH_\܂B
 *
 * AudioLogPathName vpeB̏l "" łB
 *
 * @param recognizer FGW̃nhB
 * @param audioLogPathName ݒ肷 AudioLogPathName vpeB̒lB
 *
 * @retval true AudioLogPathName vpeB̒l̐ݒɐB
 * @retval false AudioLogPathName vpeB̒l̐ݒɎsB
 *
 * @warning Windows Mobile n OS ̏ꍇ́AtH_΃pXŎw肷Kv܂B
 *
 * @see amiGetAudioLogPathName()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetAudioLogPathName(AMI_RECOGNIZER recognizer, const TCHAR* audioLogPathName);

/**
 * AudioLogPathName vpeB̒l擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return AudioLogPathName vpeB̒lB
 *
 * @see amiSetAudioLogPathName()
 */
XCWRAPPER_API const TCHAR* XCWRAPPER_API_CALL amiGetAudioLogPathName(AMI_RECOGNIZER recognizer);

/**
 * AudioLogFileName vpeB̒lݒ肵܂B
 *
 * AudioLogFileName vpeB́A
 * b؂o㉹f[^Ot@C̏õ͎t@C\܂B
 *
 * t@Cɂ͈ȉ̏𖄂ߍނƂł܂B
 * <table border="1" style="margin: 2px 0px 2px 40px;">
 *  <tr>
 *   <td valign="top"><code><nobr><font color="blue">%ymd%</font></nobr></code></td>
 *   <td>t@Cۑ̓t\ yyyymmdd ` (8 ) ̕B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top"><code><nobr><font color="blue">%hms%</font></nobr></code></td>
 *   <td>t@Cۑ̎\ hhmmss ` (6 ) ̕B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top"><code><nobr><font color="blue">%rcnt%</font></nobr></code></td>
 *   <td>amiResume() ֐܂ amiFeedDataResume() ֐ĂяoтɃJEgAbv 1` ̘AԂ[pfBO 5 ŕ\B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top"><code><nobr><font color="blue">%scnt%</font></nobr></code></td>
 *   <td>bԂo邽тɃJEgAbv 1` ̘AԂ[pfBO 5 ŕ\B<br>
 *       amiResume() ֐܂ amiFeedDataResume() ֐ĂяoƂ̘AԂ 1 ɖ߂܂B</td>
 *  </tr>
 * </table>
 *
 * f[^Ot@C̊gq́A
 * RecordingAudioLogFormat vpeB̒l (b؂o㉹f[^Ot@C̉f[^`) ɂ莩IɌ肳܂B
 * vpeB̒lɉf[^Ot@C̊gq܂߂邱Ƃ͂ł܂B
 *
 * AudioLogFileName vpeB̏l "" łB
 *
 * @param recognizer FGW̃nhB
 * @param audioLogFileName ݒ肷 AudioLogFileName vpeB̒lB
 *
 * @retval true AudioLogFileName vpeB̒l̐ݒɐB
 * @retval false AudioLogFileName vpeB̒l̐ݒɎsB
 *
 * @see amiGetAudioLogFileName()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetAudioLogFileName(AMI_RECOGNIZER recognizer, const TCHAR* audioLogFileName);

/**
 * AudioLogFileName vpeB̒l擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return AudioLogFileName vpeB̒lB
 *
 * @see amiSetAudioLogFileName()
 */
XCWRAPPER_API const TCHAR* XCWRAPPER_API_CALL amiGetAudioLogFileName(AMI_RECOGNIZER recognizer);

/**
 * AudioLogFormat vpeB̒lݒ肵܂B
 *
 * AudioLogFormat vpeB́A
 * b؂o㉹f[^Ot@C̏ỏ͎f[^` (b؂o㉹f[^Ot@Cf[^`) \܂B
 *
 * AudioLogFormat vpeB̏l #AMI_AUDIO_LOG_FORMAT_MSB (l 0) łB
 *
 * @param recognizer FGW̃nhB
 * @param audioLogFormat ݒ肷 AudioLogFormat vpeB̒lB
 * <table>
 *  <tr>
 *   <td valign="top">#AMI_AUDIO_LOG_FORMAT_MSB (l 0)</td>
 *   <td>jA PCM MSB `B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">#AMI_AUDIO_LOG_FORMAT_WAVE (l 1)</td>
 *   <td>jA PCM Wave `B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">#AMI_AUDIO_LOG_FORMAT_SPEEX (l 2)</td>
 *   <td>Speex `B</td>
 *  </tr>
 * </table>
 *
 * @retval true AudioLogFormat vpeB̒l̐ݒɐB
 * @retval false AudioLogFormat vpeB̒l̐ݒɎsB
 *
 * @see amiGetAudioLogFormat()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetAudioLogFormat(AMI_RECOGNIZER recognizer, int audioLogFormat);

/**
 * AudioLogFormat vpeB̒l擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return AudioLogFormat vpeB̒lB
 * <table>
 *  <tr>
 *   <td valign="top">#AMI_AUDIO_LOG_FORMAT_MSB (l 0)</td>
 *   <td>jA PCM MSB `B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">#AMI_AUDIO_LOG_FORMAT_WAVE (l 1)</td>
 *   <td>jA PCM Wave `B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">#AMI_AUDIO_LOG_FORMAT_SPEEX (l 2)</td>
 *   <td>Speex `B</td>
 *  </tr>
 * </table>
 *
 * @see amiSetAudioLogFormat()
 */
XCWRAPPER_API int XCWRAPPER_API_CALL amiGetAudioLogFormat(AMI_RECOGNIZER recognizer);

/**
 * RecordingAudioLogPathName vpeB̒lݒ肵܂B
 *
 * RecordingAudioLogPathName vpeB́A
 * b؂oOf[^Ot@C̏o͐tH_\܂B
 *
 * RecordingAudioLogPathName vpeB̏l "" łB
 *
 * @param recognizer FGW̃nhB
 * @param recordingAudioLogPathName ݒ肷 RecordingAudioLogPathName vpeB̒lB
 *
 * @retval true RecordingAudioLogPathName vpeB̒l̐ݒɐB
 * @retval false RecordingAudioLogPathName vpeB̒l̐ݒɎsB
 *
 * @warning Windows Mobile n OS ̏ꍇ́AtH_΃pXŎw肷Kv܂B
 *
 * @see amiGetRecordingAudioLogPathName()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetRecordingAudioLogPathName(AMI_RECOGNIZER recognizer, const TCHAR* recordingAudioLogPathName);

/**
 * RecordingAudioLogPathName vpeB̒l擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return RecordingAudioLogPathName vpeB̒lB
 *
 * @see amiSetRecordingAudioLogPathName()
 */
XCWRAPPER_API const TCHAR* XCWRAPPER_API_CALL amiGetRecordingAudioLogPathName(AMI_RECOGNIZER recognizer);

/**
 * RecordingAudioLogFileName vpeB̒lݒ肵܂B
 *
 * RecordingAudioLogFileName vpeB́A
 * b؂oOf[^Ot@C̏õ͎t@C\܂B
 *
 * t@Cɂ͈ȉ̏𖄂ߍނƂł܂B
 * <table border="1" style="margin: 2px 0px 2px 40px;">
 *  <tr>
 *   <td valign="top"><code><nobr><font color="blue">%ymd%</font></nobr></code></td>
 *   <td>t@Cۑ̓t\ yyyymmdd ` (8 ) ̕B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top"><code><nobr><font color="blue">%hms%</font></nobr></code></td>
 *   <td>t@Cۑ̎\ hhmmss ` (6 ) ̕B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top"><code><nobr><font color="blue">%rcnt%</font></nobr></code></td>
 *   <td>amiResume() ֐܂ amiFeedDataResume() ֐ĂяoтɃJEgAbv 1` ̘AԂ[pfBO 5 ŕ\B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top"><code><nobr><font color="blue">%scnt%</font></nobr></code></td>
 *   <td>bԂo邽тɃJEgAbv 1` ̘AԂ[pfBO 5 ŕ\B<br>
 *       amiResume() ֐܂ amiFeedDataResume() ֐ĂяoƂ̘AԂ 1 ɖ߂܂B</td>
 *  </tr>
 * </table>
 *
 * f[^Ot@C̊gq́A
 * RecordingAudioLogFormat vpeB̒l (b؂oOf[^Ot@C̉f[^`) ɂ莩IɌ肳܂B
 * vpeB̒lɉf[^Ot@C̊gq܂߂邱Ƃ͂ł܂B
 *
 * RecordingAudioLogFileName vpeB̏l "" łB
 *
 * @param recognizer FGW̃nhB
 * @param recordingAudioLogFileName ݒ肷 RecordingAudioLogFileName vpeB̒lB
 *
 * @retval true RecordingAudioLogFileName vpeB̒l̐ݒɐB
 * @retval false RecordingAudioLogFileName vpeB̒l̐ݒɎsB
 *
 * @see amiGetRecordingAudioLogFileName()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetRecordingAudioLogFileName(AMI_RECOGNIZER recognizer, const TCHAR* recordingAudioLogFileName);

/**
 * RecordingAudioLogFileName vpeB̒l擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return RecordingAudioLogFileName vpeB̒lB
 *
 * @see amiSetRecordingAudioLogFileName()
 */
XCWRAPPER_API const TCHAR* XCWRAPPER_API_CALL amiGetRecordingAudioLogFileName(AMI_RECOGNIZER recognizer);

/**
 * RecordingAudioLogFormat vpeB̒lݒ肵܂B
 *
 * RecordingAudioLogFormat vpeB́A
 * b؂oOf[^Ot@C̏ỏ͎f[^` (b؂oOf[^Ot@Cf[^`) \܂B
 *
 * RecordingAudioLogFormat vpeB̏l #AMI_AUDIO_LOG_FORMAT_MSB (l 0) łB
 *
 * @param recognizer FGW̃nhB
 * @param recordingAudioLogFormat ݒ肷 RecordingAudioLogFormat vpeB̒lB
 * <table>
 *  <tr>
 *   <td valign="top">#AMI_AUDIO_LOG_FORMAT_MSB (l 0)</td>
 *   <td>jA PCM MSB `B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">#AMI_AUDIO_LOG_FORMAT_WAVE (l 1)</td>
 *   <td>jA PCM Wave `B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">#AMI_AUDIO_LOG_FORMAT_SPEEX (l 2)</td>
 *   <td>Speex `B</td>
 *  </tr>
 * </table>
 *
 * @retval true RecordingAudioLogFormat vpeB̒l̐ݒɐB
 * @retval false RecordingAudioLogFormat vpeB̒l̐ݒɎsB
 *
 * @see amiGetRecordingAudioLogFormat()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetRecordingAudioLogFormat(AMI_RECOGNIZER recognizer, int recordingAudioLogFormat);

/**
 * RecordingAudioLogFormat vpeB̒l擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return RecordingAudioLogFormat vpeB̒lB
 * <table>
 *  <tr>
 *   <td valign="top">#AMI_AUDIO_LOG_FORMAT_MSB (l 0)</td>
 *   <td>jA PCM MSB `B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">#AMI_AUDIO_LOG_FORMAT_WAVE (l 1)</td>
 *   <td>jA PCM Wave `B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">#AMI_AUDIO_LOG_FORMAT_SPEEX (l 2)</td>
 *   <td>Speex `B</td>
 *  </tr>
 * </table>
 *
 * @see amiSetRecordingAudioLogFormat()
 */
XCWRAPPER_API int XCWRAPPER_API_CALL amiGetRecordingAudioLogFormat(AMI_RECOGNIZER recognizer);

/**
 * SamplesPerSec vpeB̒lݒ肵܂B
 *
 * SamplesPerSec vpeB́A
 * amiResume() ֐ɂ^foCX^鉹f[^̃TvOg\܂B
 *
 * @param recognizer FGW̃nhB
 * @param samplesPerSec ݒ肷 SamplesPerSec vpeB̒lB
 *
 * @retval true SamplesPerSec vpeB̒l̐ݒɐB
 * @retval false SamplesPerSec vpeB̒l̐ݒɎsB
 *
 * @see amiGetSamplesPerSec()
 * @see amiResume()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetSamplesPerSec(AMI_RECOGNIZER recognizer, int samplesPerSec);

/**
 * SamplesPerSec vpeB̒l擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return SamplesPerSec vpeB̒lB
 *
 * @see amiSetSamplesPerSec()
 */
XCWRAPPER_API int XCWRAPPER_API_CALL amiGetSamplesPerSec(AMI_RECOGNIZER recognizer);

/**
 * DeviceId vpeB̒lݒ肵܂B
 *
 * DeviceId vpeB́A
 * amiResume() ֐ɂ^JnۂɎgp^foCX ID \܂B
 *
 * DeviceId vpeBɓK؂Ș^foCX ID w肳ꂽꍇ́A
 * DeviceName vpeB̒lw肳ꂽ^foCX ID ^foCX̖Oɏ܂B
 *
 * DeviceId vpeBɓK؂łȂ^foCX ID w肳ꂽꍇ́A
 * DeviceName vpeB̒l "" ɏ܂B
 *
 * DeviceId vpeB̏l -1 (̘^foCX) łB
 *
 * @param recognizer FGW̃nhB
 * @param deviceId ݒ肷 DeviceId vpeB̒lB
 *
 * @retval true DeviceId vpeB̒l̐ݒɐB
 * @retval false DeviceId vpeB̒l̐ݒɎsB
 *
 * @warning Windows n Windows Mobile n OS ł̂ݗp邱Ƃł܂B
 *
 * @see amiGetDeviceId()
 * @see amiSetDeviceName()
 * @see amiGetDeviceName()
 * @see amiResume()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetDeviceId(AMI_RECOGNIZER recognizer, int deviceId);

/**
 * DeviceId vpeB̒l擾܂B
 *
 * A deviceName  NULL ȊO̒lw肳ꂽꍇ́A
 *  deviceName Ɏw肳ꂽ^foCXɈv^foCX ID Ԃ܂B
 *
 * @param recognizer FGW̃nhB
 * @param deviceName ^foCXB
 *
 * @return DeviceId vpeB̒lB
 *
 * @warning Windows n Windows Mobile n OS ł̂ݗp邱Ƃł܂B
 *
 * @see amiSetDeviceId()
 * @see amiSetDeviceName()
 * @see amiGetDeviceName()
 * @see amiSetDeviceInfo()
 * @see amiGetDeviceInfo()
 * @see amiResume()
 */
XCWRAPPER_API int XCWRAPPER_API_CALL amiGetDeviceId(AMI_RECOGNIZER recognizer, const TCHAR* deviceName);

/**
 * DeviceName vpeB̒lݒ肵܂B
 *
 * DeviceName vpeB́A
 * amiResume() ֐ɂ^JnۂɎgp^foCX̖O\܂B
 *
 * DeviceName vpeBɓK؂Ș^foCXw肳ꂽꍇ́A
 * DeviceId vpeB̒lw肳ꂽ^foCXɈv^foCX ID ɏ܂B
 *
 * DeviceName vpeBɓK؂łȂ^foCXw肳ꂽꍇ́A
 * DeviceId vpeB̒l -1 ɏ܂B
 *
 * @param recognizer FGW̃nhB
 * @param deviceName ݒ肷 DeviceId vpeB̒lB
 *
 * @retval true deviceName vpeB̒l̐ݒɐB
 * @retval false deviceName vpeB̒l̐ݒɎsB
 *
 * @warning Windows n Windows Mobile n OS ł̂ݗp邱Ƃł܂B
 *
 * @see amiSetDeviceId()
 * @see amiGetDeviceId()
 * @see amiGetDeviceName()
 * @see amiResume()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetDeviceName(AMI_RECOGNIZER recognizer, const TCHAR* deviceName);

/**
 * DeviceName vpeB̒l擾܂B
 *
 * A deviceId  -1 ȊO̒lw肳ꂽꍇ́A
 *  deviceId Ɏw肳ꂽ^foCX ID ^foCX̖OԂ܂B
 *
 * @param recognizer FGW̃nhB
 * @param deviceId ^foCX IDB
 *
 * @return DeviceName vpeB̒lB
 *
 * @warning Windows n Windows Mobile n OS ł̂ݗp邱Ƃł܂B
 *
 * @see amiSetDeviceId()
 * @see amiGetDeviceId()
 * @see amiSetDeviceName()
 * @see amiResume()
 */
XCWRAPPER_API const TCHAR* XCWRAPPER_API_CALL amiGetDeviceName(AMI_RECOGNIZER recognizer, int deviceId);

/**
 * T[ovpeB̒l𕶎񂩂ݒ肵܂B
 *
 * @param recognizer FGW̃nhB
 * @param serverProperties ݒ肷T[ovpeB̒lB<br>
 *                         vpeBƒl "=" (pCR[) Ōт܂B<br>
 *                         ̃vpeBw肷ꍇ "&nbsp;" (pXy[X) ŋ؂܂B
 * <table>
 *  <tr>
 *   <td valign="top">serverName</td>
 *   <td>FT[o (&lt;zXg&gt;:&lt;|[gԍ&gt; `)B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">serverName2</td>
 *   <td>ZJ_FT[o (&lt;zXg&gt;:&lt;|[gԍ&gt; `)B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">httpServerName</td>
 *   <td>AmiVoice DSR HTTP T[o (&lt;zXg&gt;:&lt;|[gԍ&gt; `)B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">proxyServerName</td>
 *   <td>vLVT[o (&lt;zXg&gt;:&lt;|[gԍ&gt; `)B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">sslEnabled</td>
 *   <td>FT[oƂ̒ʐM SSL ňÍ邩ǂBȗl falseB<br>
 *        SSL ʐM̃T|[gLɂԂŃrhꂽCu ({@link #getInternalVersion} \bhԂo[W̕ "_ssl" ܂܂郉Cu) ł̂ݗp邱Ƃł܂B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">timeout</td>
 *   <td>FT[oƂ̐ڑʐMɂ^CAEg (PʁF~b)B
 *       ڑJn timeout vpeBɎw肳ꂽԂo߂ĂڑłȂ΁AڑsƂ݂Ȃ܂B
 *       timeoutEnabled vpeB true ݒ肳ĂꍇA
 *       bJn甭bԂ 3 {̎ԁA܂́Atimeout vpeBɎw肳ꂽԂ̂ꂩ傫̎Ԃo߂ĂFʏFT[oMłȂ΁A
 *       ȗl 10000 (10 b)B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">timeoutEnabled</td>
 *   <td>FT[oƂ̒ʐMɂ^CAEgsǂB
 *       timeoutEnabled vpeB true ݒ肳ĂꍇA
 *       bJn甭bԂ 3 {̎ԁA܂́Atimeout vpeBɎw肳ꂽԂ̂ꂩ傫̎Ԃo߂ĂFʏFT[oMłȂ΁A
 *       FT[oƂ̒ʐMIɐؒf܂B
 *       ȗl trueB</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">serverAudioFormat</td>
 *   <td>FT[oɉf[^𑗐Mۂ̌`Bȗl "SPEEX"B
 *    <table>
 *     <tr>
 *      <td valign="top">"MSB"</td>
 *      <td>jA PCM MSB `B</td>
 *     </tr>
 *     <tr>
 *      <td valign="top">"FEATUREXFRAME"</td>
 *      <td>kʌ`B</td>
 *     </tr>
 *     <tr>
 *      <td valign="top">"FEATUREXPFRAME"</td>
 *      <td>sb`tkʌ`B</td>
 *     </tr>
 *     <tr>
 *      <td valign="top">"SPEEX"</td>
 *      <td>Speex `B</td>
 *     </tr>
 *    </table>
 *   </td>
 *  </tr>
 *  <tr>
 *   <td valign="top">speexQuality</td>
 *   <td>FT[o Speex `ŉf[^𑗐Mۂ̕i (0`10)Bȗl 8B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">terminalInfo</td>
 *   <td>[Bȗl ""B<br>
 *       Ŏw肳ꂽ́AXCWrapper Cũo[WƈꏏɉFT[oւ̐ڑɑM܂B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">terminalId</td>
 *   <td>[ IDBȗl ""B<br>
 *       Ŏw肳ꂽ́AFT[oւ̐ڑɑM܂B<br>
 *       pҌ@\LɂȂFT[oɐڑꍇ́AuT[rX IDvK擪Ɋi[ (؂蕶 ':' (pR)) ꂽ[ ID w肷Kv܂B<br>
 *       <br>
 *       terminalId=<font color="blue">&lt;[ID&gt;</font><br>
 *       terminalId=<font color="blue">&lt;T[rXID&gt;</font>:<br>
 *       terminalId=<font color="blue">&lt;T[rXID&gt;</font>:<font color="blue">&lt;[ID&gt;</font><br>
 *       <br>
 *       u[ IDvсuT[rX IDvɂ́A'0'`'9'A'A'`'Z'A'a'`'z'A'-'A'_' ȊO̕gp邱Ƃ͂ł܂B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">password</td>
 *   <td>T[rXpX[hBȗl ""B(ݒp)<br>
 *       pҌ@\LɂȂFT[oɐڑꍇ́AKuT[rXpX[hvw肷Kv܂B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">extension</td>
 *   <td>gBȗl ""B
 *       Ŏw肳ꂽ́AFT[oւ̐ڑɑM܂B</td>
 *  </tr>
 * </table>
 *
 * @retval true T[ovpeB̒l̐ݒɐB
 * @retval false T[ovpeB̒l̐ݒɎsB
 *
 * @see amiGetServerProperties()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiSetServerProperties(AMI_RECOGNIZER recognizer, const TCHAR* serverProperties);

/**
 * T[ovpeB̒l擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return T[ovpeB̒lB
 *
 * @see amiSetServerProperties()
 */
XCWRAPPER_API const TCHAR* XCWRAPPER_API_CALL amiGetServerProperties(AMI_RECOGNIZER recognizer);

/**
 * ^Jn܂B
 *
 * DeviceId vpeBŐݒ肳Ă^foCX IDA
 * ܂́A
 * DeviceName vpeBŐݒ肳Ă^foCX^̂߂Ɏgp^foCX肵܂B
 *
 * DeviceName vpeB "" łȂK؂Ș^foCXݒ肳Ăꍇ́A
 * DeviceName vpeBŐݒ肳Ă^foCX^̂߂Ɏgp^foCX肵܂B
 * DeviceName vpeBŐݒ肳Ă^foCXɈv^foCXȂꍇ́A
 * ^̊JnɎs܂ (߂lƂ false Ԃ܂)B
 *
 * DeviceName vpeB "" ݒ肳Ăꍇ́A
 * DeviceId vpeBŐݒ肳Ă^foCX ID ^̂߂Ɏgp^foCX肵܂B
 * DeviceId vpeBŐݒ肳Ă^foCX ID ^foCXȂꍇ́A
 * ^̊JnɎs܂ (߂lƂ false Ԃ܂)B
 *
 * ^̂߂Ɏgp^foCX肳ꂽA
 * SamplesPerSec vpeBŐݒ肳ĂTvOg̉f[^̘^Jn܂B
 *
 * ^܂͉FGWւ̉f[^̋ (amiIsActive()==true)A܂́A
 * F (amiIsRecognizing()==true) ̏Ԃɂ鎞́A
 * ^Jn邱Ƃł܂ (߂lƂ false Ԃ܂) ̂ŁAӂĂB
 *
 * @param recognizer FGW̃nhB
 *
 * @retval true ^̊JnɐB
 * @retval false ^̊JnɎsB
 *
 * @warning }`Xbh[h̏ꍇ̂݌ĂяoƂł܂B
 * @warning Android nȊO OS ł̂ݗp邱Ƃł܂B
 *
 * @see amiSetDeviceId()
 * @see amiSetDeviceName()
 * @see amiPause()
 * @see amiIsActive()
 * @see amiIsRecognizing()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiResume(AMI_RECOGNIZER recognizer);

/**
 * ^~܂B
 *
 * @param recognizer FGW̃nhB
 * @param cancel Ff邩ǂB
 * <table>
 *  <tr>
 *   <td valign="top">true</td>
 *   <td>Ff܂B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">false</td>
 *   <td>Ff܂B</td>
 *  </tr>
 * </table>
 * @param blocking F܂ŃubN邩ǂB
 * <table>
 *  <tr>
 *   <td valign="top">true</td>
 *   <td>F܂ŃubN܂B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">false</td>
 *   <td>F܂ŃubN܂B</td>
 *  </tr>
 * </table>
 *
 * @retval true ^̒~ɐB
 * @retval false ^̒~ɎsB
 *
 * @warning }`Xbh[h̏ꍇ̂݌ĂяoƂł܂B
 * @warning Android nȊO OS ł̂ݗp邱Ƃł܂B
 *
 * @see amiResume()
 * @see amiIsActive()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiPause(AMI_RECOGNIZER recognizer, bool cancel, bool blocking);

/**
 * FǂԂ܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @retval true F̎B
 * @retval false FłȂB
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiIsRecognizing(AMI_RECOGNIZER recognizer);

/**
 * ^܂͉FGWւ̉f[^̋ǂԂ܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @retval true ^܂͉FGWւ̉f[^̋̎B
 * @retval false ^łFGWւ̉f[^̋łȂB
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiIsActive(AMI_RECOGNIZER recognizer);

/**
 * XCWrapper Cuɒ~ςĂ鉹f[^̃oCgԂ܂B
 *
 * @return XCWrapper Cuɒ~ςĂ鉹f[^̃oCgB
 */
XCWRAPPER_API int XCWRAPPER_API_CALL amiGetBufferedDataByteCount(AMI_RECOGNIZER recognizer);

/**
 * XCWrapper Cuɒ~ςĂ鉹f[^̔bԂ܂B
 *
 * @return XCWrapper Cuɒ~ςĂ鉹f[^̔bB
 */
XCWRAPPER_API int XCWRAPPER_API_CALL amiGetBufferedUtteranceCount(AMI_RECOGNIZER recognizer);

/**
 * ݂̉̓x擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return ݂̉̓xB
 */
XCWRAPPER_API int XCWRAPPER_API_CALL amiGetVolume(AMI_RECOGNIZER recognizer);

/**
 * O̔b S/N 擾܂B
 *
 * ֐́AbICxg (#AMI_RESULT_STATE_UTTERANCE_ENDED) ɑR[obN֐̒ŌĂяo悤ɂĂB
 *
 * @param recognizer FGW̃nhB
 * @param mode 擾l̎ށB
 * <table>
 *  <tr>
 *   <td valign="top">0</td>
 *   <td>O̔b S/N  (PʁFdB) 擾܂B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">1</td>
 *   <td>O̔b̔b̑ΐp[ (PʁFdB) 擾܂B</td>
 *  </tr>
 *  <tr>
 *   <td valign="top">2</td>
 *   <td>O̔b̔񔭘b̑ΐp[ (PʁFdB) 擾܂B</td>
 *  </tr>
 * </table>
 *
 * @retval mode==0 O̔b S/N  (PʁFdB)B
 * @retval mode==1 O̔b̔b̑ΐp[ (PʁFdB)B
 * @retval mode==2 O̔b̔񔭘b̑ΐp[ (PʁFdB)B
 */
XCWRAPPER_API int XCWRAPPER_API_CALL amiGetSNR(AMI_RECOGNIZER recognizer, int mode);

/**
 * ݂̂l擾܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return ݂̂lB
 */
XCWRAPPER_API int XCWRAPPER_API_CALL amiGetThreshold(AMI_RECOGNIZER recognizer);

/**
 * Ōɕۑꂽb؂o㉹f[^Ot@CԂ܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return Ōɕۑꂽb؂o㉹f[^Ot@CB
 */
XCWRAPPER_API const TCHAR* XCWRAPPER_API_CALL amiGetSegmentedAudioLogFileName(AMI_RECOGNIZER recognizer);

/**
 * Ōɕۑꂽb؂oOf[^Ot@CԂ܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @return Ōɕۑꂽb؂oOf[^Ot@CB
 */
XCWRAPPER_API const TCHAR* XCWRAPPER_API_CALL amiGetRecordedAudioLogFileName(AMI_RECOGNIZER recognizer);

/**
 * VOXbh[hŉf[^ɑ΂FsȂ܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @retval true VOXbh[hł̉f[^̔FɐB
 * @retval false VOXbh[hł̉f[^̔FɎsB
 *
 * @warning VOXbh[h̏ꍇ̂݌ĂяoƂł܂B
 *
 * @see amiInitialize()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiDecode(AMI_RECOGNIZER recognizer);

/**
 * F̋fv󂯕t܂B
 *
 * ^܂͉FGWւ̉f[^̋̏ (amiIsActive()==true)A
 * ܂́AFłȂ (amiIsRecognizing()==false) ɂ鎞́A
 * F̋fv󂯕t܂ (߂lƂ false Ԃ܂) ̂ŁAӂĂB
 *
 * F̋fv󂯕tꍇłA
 * F܂ŃubN͂܂̂ŁAӂĂB
 *
 * @param recognizer FGW̃nhB
 *
 * @retval true F̋fv󂯕tB
 * @retval false F̋fv󂯕tȂB
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiCancelRecognizing(AMI_RECOGNIZER recognizer);

/**
 * FT[oɐڑ܂B
 *
 * }`Xbh[hŏĂȂꍇfalse Ԃ܂B
 *
 * @param recognizer FGW̃nhB
 * @param grammarFileNames O}t@CQB
 *
 * @retval true FT[oւ̐ڑɐB
 * @retval false FT[oւ̐ڑɎsB
 *
 * @see amiDisconnect()
 * @see amiIsConnecting()
 * @see amiIsConnected()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiConnect(AMI_RECOGNIZER recognizer, const TCHAR* grammarFileNames);

/**
 * FT[oƂ̐ڑؒf܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @retval true FT[oƂ̐ڑ̐ؒfɐB
 * @retval false FT[oƂ̐ڑ̐ؒfɎsB
 *
 * @see amiConnect()
 * @see amiIsConnected()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiDisconnect(AMI_RECOGNIZER recognizer);

/**
 * FT[oւ̐ڑǂԂ܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @retval true FT[oւ̐ڑ̎B
 * @retval false FT[oւ̐ڑłȂB
 *
 * @see amiConnect()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiIsConnecting(AMI_RECOGNIZER recognizer);

/**
 * FT[oɐڑǂԂ܂B
 *
 * @param recognizer FGW̃nhB
 *
 * @retval true FT[oɐڑ̎B
 * @retval false FT[oɐڑłȂB
 *
 * @see amiConnect()
 * @see amiDisconnect()
 */
XCWRAPPER_API bool XCWRAPPER_API_CALL amiIsConnected(AMI_RECOGNIZER recognizer);

/**
 * XbhX[vs܂B
 *
 * @param timeout X[v (PʁF~b)B
 *
 * @return (Ȃ)
 */
XCWRAPPER_API void XCWRAPPER_API_CALL amiSleep(int timeout);
#ifdef __cplusplus
}
#endif

#endif /* _XCWRAPPER_H_ */
