/**
 * Copyright (C) 2002-2013 Advanced Media, Inc. All Rights Reserved.
 *
 * XCWrapper TvvO
 *  }`Xbh[hŁA}CN烋[O}gpĔFs܂B
 */

#include "stdafx.h"
#include "xcwrapper_trial.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>

// FʎMpR[obN֐vg^Cv錾
void XCWRAPPER_API_CALL AmiVoice_ResultEventCallBack(AMI_RESULT* result, AMI_RESULT_EVENT_USERDATA userData);

// FGW\[Xt@C
TCHAR* _dsrServerName = _T("assistcom.amivoice.com:34123");
// O}t@C
TCHAR* _grammarFileName = _T("-AmiMobileIPhone16k_BigVocabMail_noAlt");

// Fʐő吔
int _maxResultCount = 3;

// Fʐ
int _resultCount = 0;

// C֐
int _tmain(int argc, TCHAR** argv) {
	if (argc < 5) {
		_tprintf(_T("used: dsr <dsrServerName> <grammarFileName> <terminalId> <password>\n"));
		return 1;
	}
	// ̃`FbN
	TCHAR* dsrServerName = _dsrServerName;
	if (argc > 1 && _tcscmp(argv[1], _T(".")) != 0) {
		dsrServerName = argv[1];
	}
	TCHAR* grammarFileName = _grammarFileName;
	if (argc > 2 && _tcscmp(argv[2], _T(".")) != 0) {
		grammarFileName = argv[2];
	}
	TCHAR* terminalId = _T("");
	if (argc > 3 && _tcscmp(argv[3], _T(".")) != 0) {
		terminalId = argv[3];
	}
	TCHAR* password = _T("");
	if (argc > 4 && _tcscmp(argv[4], _T(".")) != 0) {
		password = argv[4];
	}

	// P[̐ݒ
	setlocale(LC_ALL, "");

	// XCWrapper Cȕ
	AMI_RECOGNIZER recognizer = amiInitialize(true, _T(""), _T(""));
	_tprintf(_T("INFO: initialized XCWrapper %s version %s (muitl thread mode)\n"), amiGetInternalVersion(), amiGetVersion());

	// FʎMpR[obN֐̐ݒ
	amiSetResultEvent(recognizer, AmiVoice_ResultEventCallBack, NULL, NULL, NULL);

	// XCWrapper CũvpeB̐ݒ
	amiSetConfidenceLevel(recognizer, 0.4f);
	TCHAR serverProperties[256];
	_stprintf(serverProperties, _T("serverName=%s terminalId=%s password=%s"), dsrServerName, terminalId, password);
	// T[ovpeB̃Zbg
	if (!amiSetServerProperties(recognizer, serverProperties)) {
		_tprintf(_T("ERROR: can't set server properties: %s\n"), serverProperties);
		// XCWrapper CȕI
		amiTerminate(recognizer);
		_tprintf(_T("INFO: terminated AmiVoice\n"));
		return 2;
	}
	_tprintf(_T("INFO: set server properties: %s\n"), serverProperties);

	// ^foCX̐ݒ(Pidora ̏ꍇ͓0AUSB 1 ƂȂ܂)
	// TvOg͕ύXł܂B
	amiSetDeviceId(recognizer, 1);

	// DSR T[oɐڑ
	if (!amiConnect(recognizer, grammarFileName)) {
		_tprintf(_T("ERROR: can't connect server\n"));

		// XCWrapper CȕI
		amiTerminate(recognizer);
		_tprintf(_T("INFO: terminated AmiVoice\n"));
		return 3;
	}

	// ͂̊Jn
	if (amiResume(recognizer)) {
		_tprintf(_T("INFO: resumed recording\n"));
	} else {
		_tprintf(_T("INFO: can't resume\n"));
	}

	// f[^̏
	while (_resultCount < _maxResultCount && (amiIsActive(recognizer) || amiIsRecognizing(recognizer))) {
		// 1 bԂ̑ҋ@
		amiSleep(1000);
	}

	// ͂̒~
	amiPause(recognizer, /* cancel */ true, /* blocking */ true);
	_tprintf(_T("INFO: paused recording and decoded %d results\n"), _resultCount);

	// XCWrapper CȕI
	amiTerminate(recognizer);
	_tprintf(_T("INFO: terminated AmiVoice\n"));

	// vȌI
	return 0;
}

// FʎMpR[obN֐
void XCWRAPPER_API_CALL AmiVoice_ResultEventCallBack(AMI_RESULT* result, AMI_RESULT_EVENT_USERDATA userData) {
	switch (result->state) {
	case AMI_RESULT_STATE_RESUMED:
		_tprintf(_T("EVENT: RESUMED\n"));
		break;
	case AMI_RESULT_STATE_PAUSED:
		_tprintf(_T("EVENT: PAUSE\n"));
		break;
	case AMI_RESULT_STATE_UTTERANCE_STARTED:
		_tprintf(_T("EVENT: UTTERANCE_STARTED\n"));
		break;
	case AMI_RESULT_STATE_UTTERANCE_ENDED:
		_tprintf(_T("EVENT: UTTERANCE_ENDED\n"));
		break;
	case AMI_RESULT_STATE_UTTERANCE_TOO_LONG:
		_tprintf(_T("EVENT: UTTERANCE_TOO_LONG\n"));
		break;
	case AMI_RESULT_STATE_UTTERANCE_TOO_LOUD:
		_tprintf(_T("EVENT: UTTERANCE_TOO_LOUD\n"));
		break;
	case AMI_RESULT_STATE_RESULT_CREATED:
		_tprintf(_T("EVENT: RESULT_CREATED\n"));
		break;
	case AMI_RESULT_STATE_RESULT_UPDATED:
		_tprintf(_T("EVENT: RESULT_UPDATED: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
		break;
	case AMI_RESULT_STATE_RESULT_ACCEPTED:
		_tprintf(_T("EVENT: RESULT_ACCEPTED\n"));
		if (result->result != NULL && strlen(result->result) != 0) {
			const TCHAR* table[] = {_T("token"), _T("confidence"), _T("timetag"), _T("tag"), _T("ruleName"), _T("reserved"), _T("audioLogFileName")};
			TCHAR* resultInternal = new TCHAR[strlen(result->result) + 1];
			strcpy(resultInternal, result->result);

			TCHAR* index = resultInternal;
			TCHAR* results[7];
			memset(results, 0, sizeof(TCHAR*) * 7);

			// token, confidence, timetag \
			for (int i = 0; i < 3; i++) {
				// 0x01 ŔFʂ𕪊
				TCHAR* foundIndex = _tcschr(index, (TCHAR)0x01);
				if (foundIndex == NULL) {
					break;
				}
				results[i] = index;
				*foundIndex = 0;
				index = foundIndex + 1;
				if (i == 0) {
					printf("%s : \n", table[i]);
					TCHAR* token = results[i];

					// '|' ŕĔFʂo͂
					TCHAR* index2 = _tcschr(token, '|');
					while (index2 != NULL) {
						*index2 = 0;
						printf("\t%s\n", token);
						token = index2 + 1;
						index2 = _tcschr(token , '|');
					}
					printf("\t%s\n", token);
				} else {
					printf("%s : %s\n", table[i], (results[i] != NULL ? results[i]: "(none)"));
				}
			}
			delete resultInternal;
		}
		_resultCount++;
		break;
	case AMI_RESULT_STATE_RESULT_REJECTED:
		_tprintf(_T("EVENT: RESULT_REJECTED: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
		break;
	case AMI_SERVER_STATE_LOOKUP_ERROR:
		_tprintf(_T("EVENT: LOOKUP_ERROR: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
		break;
	case AMI_SERVER_STATE_CONNECT_ERROR:
		_tprintf(_T("EVENT: CONNECT_ERROR: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
		break;
	case AMI_SERVER_STATE_CONFIRM_ERROR:
		_tprintf(_T("EVENT: CONFIRM_ERROR: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
		break;
	case AMI_SERVER_STATE_VALIDATE_ERROR:
		_tprintf(_T("EVENT: VALIDATE_ERROR: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
		break;
	case AMI_SERVER_STATE_CANCELLED_CONNECTING:
		_tprintf(_T("EVENT: CANCELLED_CONNECTING: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
		break;
	case AMI_SERVER_STATE_CONNECTED:
		_tprintf(_T("EVENT: CONNECTED: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
		break;
	case AMI_SERVER_STATE_SEND_ERROR:
		_tprintf(_T("EVENT: SEND_ERROR: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
		break;
	case AMI_SERVER_STATE_RECV_ERROR:
		_tprintf(_T("EVENT: RECV_ERROR: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
		break;
	case AMI_SERVER_STATE_DISCONNECTED_BY_FORCE:
		_tprintf(_T("EVENT: DISCONNECTED_BY_FORCE: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
		break;
	}
}
