/**
 * Copyright (C) 2002-2013 Advanced Media, Inc. All Rights Reserved.
 *
 * XCWrapper TvvO
 *  }`Xbh[hŁA}CN烋[O}gpĔFs܂B
 */

#include "stdafx.h"
#include "xcwrapper_trial.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>

// FʎMpR[obN֐vg^Cv錾
void XCWRAPPER_API_CALL AmiVoice_ResultEventCallBack(AMI_RESULT* result, AMI_RESULT_EVENT_USERDATA userData);

// R[hϊe[upX
TCHAR* _tablePathName = _T("../../res/tables");

#if defined(RASPBERRYPI)
 // FGW\[Xt@C
 TCHAR* _resourceFileName = _T("../../res/systems/AmiDesktop16k_RunMelos_lm/recognizer.xc");
 // O}t@C
 TCHAR* _grammarFileName = _T("-");
#else
 // FGW\[Xt@C
 TCHAR* _resourceFileName = _T("../../res/systems/AmiDesktop16k_RunMelos_lm/recognizer.xc");
 // O}t@C
 TCHAR* _grammarFileName = _T("-");
#endif



// Fʐő吔
int _maxResultCount = 3;

// Fʐ
int _resultCount = 0;

// C֐
int _tmain(int argc, TCHAR** argv) {
	// ̃`FbN
	TCHAR* tablePathName = _tablePathName;
	if (argc > 1 && _tcscmp(argv[1], _T(".")) != 0) {
		tablePathName = argv[1];
	}
	TCHAR* resourceFileName = _resourceFileName;
	if (argc > 2 && _tcscmp(argv[2], _T(".")) != 0) {
		resourceFileName = argv[2];
	}
	TCHAR* grammarFileName = _grammarFileName;
	if (argc > 3 && _tcscmp(argv[3], _T(".")) != 0) {
		grammarFileName = argv[3];
	}

	// P[̐ݒ
	setlocale(LC_ALL, "");

	// XCWrapper Cȕ
	AMI_RECOGNIZER recognizer = amiInitialize(true, _T(""), _T(""));
	_tprintf(_T("INFO: initialized XCWrapper %s version %s (muitl thread mode)\n"), amiGetInternalVersion(), amiGetVersion());

	// FʎMpR[obN֐̐ݒ
	amiSetResultEvent(recognizer, AmiVoice_ResultEventCallBack, NULL, NULL, NULL);

	// FGW̃[h
	if (!amiLoadRecognizer(recognizer, resourceFileName)) {
		_tprintf(_T("ERROR: can't load recognizer: %s\n"), resourceFileName);
		// XCWrapper CȕI
		amiTerminate(recognizer);
		_tprintf(_T("INFO: terminated AmiVoice\n"));
		return 1;
	}
	_tprintf(_T("INFO: loaded recognizer: %s\n"), resourceFileName);

	// O}̃[h
	if (!amiSetGrammars(recognizer, grammarFileName)) {
		_tprintf(_T("ERROR: can't load grammar: %s\n"), grammarFileName);
		// FGW̉
		amiUnloadRecognizer(recognizer);
		_tprintf(_T("INFO: unloaded recognizer\n"));

		// XCWrapper CȕI
		amiTerminate(recognizer);
		_tprintf(_T("INFO: terminated AmiVoice\n"));
		return 2;
	}
	_tprintf(_T("INFO: loaded grammar: %s\n"), grammarFileName);

	// LȃO}ǂݍ܂Ă邩ǂ̃`FbN
	if (!amiHasActiveGrammars(recognizer)) {
		_tprintf(_T("ERROR: can't find active grammars\n"));
		// FGW̉
		amiUnloadRecognizer(recognizer);
		_tprintf(_T("INFO: unloaded recognizer\n"));

		// XCWrapper CȕI
		amiTerminate(recognizer);
		_tprintf(_T("INFO: terminated AmiVoice\n"));
		return 4;
	}
	_tprintf(_T("INFO: found active grammars\n"));
	
	// XCWrapper CũvpeB̐ݒ
	// xdxd̐ݒ(xd <- 0.0`1.0 -> xd)
	amiSetSpeedVsAccuracy(recognizer, 0.5f);
	// Mx̐ݒ(0.0`1.0 )BMx̒l𒴂Accepted ƂȂ܂B
	amiSetConfidenceLevel(recognizer, 0.4f);
	// [h̐ݒ
	amiSetMode(recognizer, AMI_MODE_RECOGNITION | AMI_MODE_RESULT | AMI_MODE_CONFIDENCE);
	// Updated Cxg̐ݒ(0 ResultUpdated Cxg͔܂)
	amiSetResultUpdatedInterval(recognizer, 0);
	// ^foCX̐ݒ(Pidora ̏ꍇ͓0AUSB 1 ƂȂ܂)
	// TvOg͕ύXł܂B
	amiSetDeviceId(recognizer, 1);

	// ͂̊Jn
	if (amiResume(recognizer)) {
		_tprintf(_T("INFO: resumed recording\n"));
	} else {
		_tprintf(_T("INFO: can't resume\n"));
	}

	// f[^̏
	while (_resultCount < _maxResultCount && (amiIsActive(recognizer) || amiIsRecognizing(recognizer))) {
		// 1 bԂ̑ҋ@
		amiSleep(1000);
	}

	// ͂̒~
	amiPause(recognizer, /* cancel */ true, /* blocking */ true);
	_tprintf(_T("INFO: paused recording and decoded %d results\n"), _resultCount);

	// FGW̉
	amiUnloadRecognizer(recognizer);
	_tprintf(_T("INFO: unloaded recognizer\n"));

	// XCWrapper CȕI
	amiTerminate(recognizer);
	_tprintf(_T("INFO: terminated AmiVoice\n"));

	// vȌI
	return 0;
}

// FʎMpR[obN֐
void XCWRAPPER_API_CALL AmiVoice_ResultEventCallBack(AMI_RESULT* result, AMI_RESULT_EVENT_USERDATA userData) {
	if (result->state == AMI_RESULT_STATE_RESUMED) {
		_tprintf(_T("EVENT: RESUMED\n"));
	} else
	if (result->state == AMI_RESULT_STATE_PAUSED) {
		_tprintf(_T("EVENT: PAUSE\n"));
	} else
	if (result->state == AMI_RESULT_STATE_UTTERANCE_STARTED) {
		_tprintf(_T("EVENT: UTTERANCE_STARTED\n"));
	} else
	if (result->state == AMI_RESULT_STATE_UTTERANCE_ENDED) {
		_tprintf(_T("EVENT: UTTERANCE_ENDED\n"));
	} else
	if (result->state == AMI_RESULT_STATE_UTTERANCE_TOO_LONG) {
		_tprintf(_T("EVENT: UTTERANCE_TOO_LONG\n"));
	} else
	if (result->state == AMI_RESULT_STATE_UTTERANCE_TOO_LOUD) {
		_tprintf(_T("EVENT: UTTERANCE_TOO_LOUD\n"));
	} else
	if (result->state == AMI_RESULT_STATE_RESULT_CREATED) {
		_tprintf(_T("EVENT: RESULT_CREATED\n"));
	} else
	if (result->state == AMI_RESULT_STATE_RESULT_UPDATED) {
		_tprintf(_T("EVENT: RESULT_UPDATED: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
	} else
	if (result->state == AMI_RESULT_STATE_RESULT_ACCEPTED) {
		_tprintf(_T("EVENT: RESULT_ACCPETED\n"));
		if (result->result != NULL && strlen(result->result) != 0) {
			const TCHAR* table[] = {_T("token"), _T("spoken"), _T("timetag"), _T("tag"), _T("ruleName"), _T("reserved"), _T("audioLogFileName")};
			TCHAR* resultInternal = new TCHAR[strlen(result->result) + 1];
			strcpy(resultInternal, result->result);

			TCHAR* index = resultInternal;
			TCHAR* results[7];
			memset(results, 0, sizeof(TCHAR*) * 7);

			// token, confidence, timetagAtagAruleName \
			for (int i = 0; i < 5; i++) {
				// 0x01 ŔFʂ𕪊
				TCHAR* foundIndex = _tcschr(index, (TCHAR)0x01);
				if (foundIndex == NULL) {
					break;
				}
				results[i] = index;
				*foundIndex = 0;
				index = foundIndex + 1;
				printf("%s : %s\n", table[i], (results[i] != NULL ? results[i]: "(none)"));
			}
			delete resultInternal;
		}
		_resultCount++;
	} else
	if (result->state == AMI_RESULT_STATE_RESULT_REJECTED) {
		_tprintf(_T("EVENT: RESULT_REJECTED: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
	}
}
