/**
 * AmiVoice 2003 SDK
 *
 * Copyright (C) 2002-2013 Advanced Media, Inc. All Rights Reserved.
 */

#ifndef _AMI_TCHAR_H_
#define _AMI_TCHAR_H_

#include <wchar.h>
#if defined(LINUX) || defined(ANDROID) || defined(TIZEN) || defined(MACOSX) || defined(IPHONE)
#include <stdio.h>
#include <stdlib.h>  // wcstombs()
#endif

#ifdef _UNICODE

 #pragma message(" --> tchar.h [TCHAR == wchar_t]")

 typedef wchar_t		TCHAR;

 #define __TEXT(x)		L ## x
 #define _T(x)			__TEXT(x)

 #define _tprintf		wprintf
 #ifndef _stprintf
  #define _stprintf		_swprintf
 #endif
 #define _sntprintf		_snwprintf
 #define _vsntprintf	_vsnwprintf

 #define _tscanf		wscanf
 #define _ftscanf		fwscanf
 #define _stscanf		swscanf

 #define _tfopen		_wfopen
 #define _ftprintf		fwprintf
 #define _fputts		fputws
 #define _putts			_putws

 #define _ttoi			_wtoi
 #define _ttol			_wtol
 #define _ttoi64		_wtoi64
 #define _ttof			_wtof
 #define _tstof			_wtof

 #define _tcslen		wcslen
 #define _tcscat		wcscat
 #define _tcsncat		wcsncat
 #define _tcscpy		wcscpy
 #define _tcsncpy		wcsncpy
 #define _tcscmp		wcscmp
 #define _tcsicmp		_wcsicmp
 #define _tcsncmp		wcsncmp
 #define _tcsnicmp		_wcsnicmp
 #define _tcschr		wcschr
 #define _tcsrchr		wcsrchr

 #define _istalnum		iswalnum
 #define _istalpha		iswalpha
 #define _istcntrl		iswcntrl
 #define _istdigit		iswdigit
 #define _istgraph		iswgraph
 #define _istlower		iswlower
 #define _istprint		iswprint
 #define _istpunct		iswpunct
 #define _istspace		iswspace
 #define _istupper		iswupper
 #define _istxdigit		iswxdigit

 #define _tmkdir		_wmkdir
 #define _tsystem		_wsystem
 #define _tgetenv		_wgetenv
 #define _tputenv		_wputenv

 #define _tmain			wmain
 #if defined(_WIN32)
  #if defined(_WIN32_WCE)
   #if defined(_AFXDLL)
    #define _tWinMain	wWinMain
   #else
    #define _tWinMain	WinMain
   #endif
  #else
   #define _tWinMain	wWinMain
  #endif
 #endif

#else

 #pragma message(" --> tchar.h [TCHAR == char]")

 typedef char			TCHAR;

 #define __TEXT(x)		x
 #define _T(x)			__TEXT(x)

 #define _tprintf		printf
 #define _stprintf		sprintf
 #define _sntprintf		_snprintf
 #define _vsntprintf	_vsnprintf

 #define _tscanf		scanf
 #define _ftscanf		fscanf
 #define _stscanf		sscanf

 #define _tfopen		fopen
 #define _ftprintf		fprintf
 #define _fputts		fputs
 #define _putts			puts

 #define _ttoi			atoi
 #define _ttol			atol
 #define _ttoi64		_atoi64
 #define _ttof			atof
 #define _tstof			atof

 #define _tcslen		strlen
 #define _tcscat		strcat
 #define _tcsncat		strncat
 #define _tcscpy		strcpy
 #define _tcsncpy		strncpy
 #define _tcscmp		strcmp
 #define _tcsicmp		_stricmp
 #define _tcsncmp		strncmp
 #define _tcsnicmp		_strnicmp
 #define _tcschr		strchr
 #define _tcsrchr		strrchr

 #define _istalnum		isalnum
 #define _istalpha		isalpha
 #define _istcntrl		iscntrl
 #define _istdigit		isdigit
 #define _istgraph		isgraph
 #define _istlower		islower
 #define _istprint		isprint
 #define _istpunct		ispunct
 #define _istspace		isspace
 #define _istupper		isupper
 #define _istxdigit		isxdigit

 #define _tmkdir		_mkdir
 #define _tsystem		system
 #define _tgetenv		getenv
 #define _tputenv		_putenv

 #define _tmain			main
 #if defined(_WIN32)
  #define _tWinMain		WinMain
 #endif

#endif

#if defined(_WIN32)

 #define _swprintf		swprintf

 inline double _wtof(const wchar_t* x) {double y = 0; swscanf(x, L"%lf", &y); return y;}

#endif

#if defined(LINUX) || defined(TIZEN) || defined(NETBSD) || defined(MACOSX) || defined(IPHONE) || defined(TENGINE)

 typedef wchar_t		WCHAR;

 #define _snprintf		snprintf
 #define _vsnprintf		vsnprintf

 #define _swprintf		NONE

 #define _snwprintf		swprintf
 #define _vsnwprintf	vswprintf

 inline FILE* _wfopen(wchar_t* x, const wchar_t* y) {char xx[256]; wcstombs(xx, x, 255); xx[255] = 0; char yy[16]; wcstombs(yy, y,  15); yy[15] = 0; return fopen(xx, yy);}

 inline int _putws(const wchar_t* x) {return fputws(x, stdout);}

 inline long long _atoi64(const char* x) {long long y = 0; sscanf(x, "%lld", &y); return y;}

 inline int _wtoi(const wchar_t* x) {int y = 0; swscanf(x, L"%d", &y); return y;}
 inline long _wtol(const wchar_t* x) {long y = 0; swscanf(x, L"%ld", &y); return y;}
 inline long long _wtoi64(const wchar_t* x) {long long y = 0; swscanf(x, L"%lld", &y); return y;}
 inline double _wtof(const wchar_t* x) {double y = 0; swscanf(x, L"%lf", &y); return y;}

 #define _stricmp		strcasecmp
 #define _strnicmp		strncasecmp

 #define _wcsicmp		wcscasecmp
 #define _wcsnicmp		wcsncasecmp

#endif

#if defined(ANDROID)

 typedef wchar_t		WCHAR;

 #define _snprintf		snprintf
 #define _vsnprintf		vsnprintf

 #define _swprintf		NONE

 #define _snwprintf		swprintf
 #define _vsnwprintf	vswprintf

 inline FILE* _wfopen(wchar_t* x, const wchar_t* y) {char xx[256]; wcstombs(xx, x, 255); xx[255] = 0; char yy[16]; wcstombs(yy, y,  15); yy[15] = 0; return fopen(xx, yy);}

 inline int _putws(const wchar_t* x) {return fputws(x, stdout);}

 inline long long _atoi64(const char* x) {long long y = 0; sscanf(x, "%lld", &y); return y;}

 inline int _wtoi(const wchar_t* x) {
	char z[32];
	int n = 0;
	while (*x != 0 && n < 32 - 1) {
		z[n++] = *x++;
	}
	z[n++] = 0;
	int y = 0; sscanf(z, "%d", &y); return y;
 }
 inline long _wtol(const wchar_t* x) {
	char z[32];
	int n = 0;
	while (*x != 0 && n < 32 - 1) {
		z[n++] = *x++;
	}
	z[n++] = 0;
	long y = 0; sscanf(z, "%ld", &y); return y;
 }
 inline long long _wtoi64(const wchar_t* x) {
	char z[32];
	int n = 0;
	while (*x != 0 && n < 32 - 1) {
		z[n++] = *x++;
	}
	z[n++] = 0;
	long long y = 0; sscanf(z, "%lld", &y); return y;
 }
 inline double _wtof(const wchar_t* x) {
	char z[32];
	int n = 0;
	while (*x != 0 && n < 32 - 1) {
		z[n++] = *x++;
	}
	z[n++] = 0;
	double y = 0; sscanf(z, "%lf", &y); return y;
 }

 #define _stricmp		strcasecmp
 #define _strnicmp		strncasecmp

 #define _wcsicmp		wcscasecmp
 #define _wcsnicmp		wcsncasecmp

 #define wcslen			ANDROID_wcslen
 #define wcscpy			ANDROID_wcscpy
 #define wcsncpy		ANDROID_wcsncpy
 #define wcscmp			ANDROID_wcscmp
 #define wcsncmp		ANDROID_wcsncmp

 inline size_t ANDROID_wcslen(const wchar_t* s) {
	size_t n = 0;
	while (*s != 0) {
		n++;
		s++;
	}
	return n;
 }

 inline wchar_t* ANDROID_wcscpy(wchar_t* d, const wchar_t* s) {
	wchar_t* od = d;
	while (*s != 0) {
		*d++ = *s++;
	}
	*d = 0;
	return od;
 }

 inline wchar_t* ANDROID_wcsncpy(wchar_t* d, const wchar_t* s, size_t n) {
	wchar_t* od = d;
	while (*s != 0 && n > 0) {
		*d++ = *s++;
		n--;
	}
	if (n > 0) {
		*d = 0;
	}
	return od;
}

 inline int ANDROID_wcscmp(const wchar_t* a, const wchar_t* b) {
	while (*a != 0 && *b != 0) {
		if (*a != *b) {
			return ((unsigned int)*a - (unsigned int)*b > 0);
		}
		a++;
		b++;
	}
	return ((unsigned int)*a - (unsigned int)*b > 0);
 }

 inline int ANDROID_wcsncmp(const wchar_t* a, const wchar_t* b, size_t n) {
	while (*a != 0 && *b != 0 && n > 0) {
		if (*a != *b) {
			return ((unsigned int)*a - (unsigned int)*b > 0);
		}
		a++;
		b++;
		n--;
	}
	if (n == 0) {
		return 0;
	}
	return ((unsigned int)*a - (unsigned int)*b > 0);
 }

#endif

#endif /* _AMI_TCHAR_H_ */
