#ifndef _AMI_MUTEX_H_
#define _AMI_MUTEX_H_

#include <pthread.h>

namespace AmiSample {

extern "C" {
int pthread_mutexattr_setkind_np(pthread_mutexattr_t *attr, int kind);
}

class Mutex {
  public:
	Mutex() {
		pthread_mutexattr_init(&mutexAttr_);
		pthread_mutexattr_setkind_np(&mutexAttr_, PTHREAD_MUTEX_RECURSIVE_NP);
		pthread_mutex_init(&mutex_, &mutexAttr_);
	}

	~Mutex() {
		pthread_mutexattr_destroy(&mutexAttr_);
		pthread_mutex_destroy(&mutex_);
	}

	Mutex& operator=(const Mutex& mutex) {
		return *this;
	}

	void lock() {
		pthread_mutex_lock(&mutex_);
	}

	void unlock() {
		pthread_mutex_unlock(&mutex_);
	}

  private:
	pthread_mutex_t mutex_;
	pthread_mutexattr_t mutexAttr_;
};

class MutexLock {
  public:
	inline MutexLock(Mutex& mutex) : mutex_(mutex) {
		mutex_.lock();
	}

	inline ~MutexLock() {
		mutex_.unlock();
	}

  private:
	// hide
	MutexLock(const MutexLock& obj);
	MutexLock& operator=(const MutexLock& obj);

  private:
	Mutex& mutex_;
};

} // namespace AMI

#endif /* _AMI_MUTEX_H_ */
