/**
 * Copyright (C) 2002-2013 Advanced Media, Inc. All Rights Reserved.
 *
 * XCWrapper TvvO
 *  }`Xbh[hŁA}CN烋[O}gpĔFs܂B
 */

#include "stdafx.h"
#include "xcwrapper_trial.h"
#include "AmiThread.h"

#include <fcntl.h>
#include <locale.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <unistd.h>

// FGW\[Xt@C
const TCHAR* _resourceFileName = _T("../../res/systems/AmiRuleExp/recognizer.xc");
// O}t@C
const TCHAR* _grammarFileName = _T("../../res/grammars/ARDrone.gram");
// R[hϊe[upX
const TCHAR* _tablePathName = _T("../../res/tables");

class ARDrone : public AmiSample::Thread {
public:
	ARDrone() {
		terminationRequested_ = false;
		mutex_ = new AmiSample::Mutex();
		resultCount_ = 0;
		command_ = NULL;
	}

	~ARDrone() {
		stop();

		if (command_ != NULL) {
			Command* command = command_;
			while (command_ != NULL) {
				command = (Command*)command_->next_;
				delete command_;
				command_ = command;
			}
		}
		if (mutex_) {
			delete mutex_;
			mutex_ = NULL;
		}
	}

	int go(int argc, TCHAR** argv) {
		// ̃`FbN
		const TCHAR* tablePathName = _tablePathName;
		if (argc > 1 && _tcscmp(argv[1], _T(".")) != 0) {
			tablePathName = argv[1];
		}
		const TCHAR* resourceFileName = _resourceFileName;
		if (argc > 2 && _tcscmp(argv[2], _T(".")) != 0) {
			resourceFileName = argv[2];
		}
		const TCHAR* grammarFileName = _grammarFileName;
		if (argc > 3 && _tcscmp(argv[3], _T(".")) != 0) {
			grammarFileName = argv[3];
		}

		// XCWrapper Cȕ
		AMI_RECOGNIZER recognizer = amiInitialize(true, _T(""), _T("-"));
		_tprintf(_T("INFO: initialized XCWrapper %s version %s (muitl thread mode)\n"), amiGetInternalVersion(), amiGetVersion());

		// FʎMpR[obN֐̐ݒ
		amiSetResultEvent(recognizer, AmiVoice_ResultEventCallBack, this, NULL, NULL);

		// FGW̃[h
		if (!amiLoadRecognizer(recognizer, resourceFileName)) {
			_tprintf(_T("ERROR: can't load recognizer: %s\n"), resourceFileName);
			// XCWrapper CȕI
			amiTerminate(recognizer);
			_tprintf(_T("INFO: terminated AmiVoice\n"));
			return 1;
		}
		_tprintf(_T("INFO: loaded recognizer: %s\n"), resourceFileName);

		// O}̃[h
		if (!amiSetGrammars(recognizer, grammarFileName)) {
			_tprintf(_T("ERROR: can't load grammar: %s\n"), grammarFileName);
			// FGW̉
			amiUnloadRecognizer(recognizer);
			_tprintf(_T("INFO: unloaded recognizer\n"));

			// XCWrapper CȕI
			amiTerminate(recognizer);
			_tprintf(_T("INFO: terminated AmiVoice\n"));
			return 2;
		}
		_tprintf(_T("INFO: loaded grammar: %s\n"), grammarFileName);

		// LȃO}ǂݍ܂Ă邩ǂ̃`FbN
		if (!amiHasActiveGrammars(recognizer)) {
			_tprintf(_T("ERROR: can't find active grammars\n"));
			// FGW̉
			amiUnloadRecognizer(recognizer);
			_tprintf(_T("INFO: unloaded recognizer\n"));

			// XCWrapper CȕI
			amiTerminate(recognizer);
			_tprintf(_T("INFO: terminated AmiVoice\n"));
			return 4;
		}
		_tprintf(_T("INFO: found active grammars\n"));

		// XCWrapper CũvpeB̐ݒ
		// xdxd̐ݒ(xd <- 0.0`1.0 -> xd)
		amiSetSpeedVsAccuracy(recognizer, 0.5f);
		// Mx̐ݒ(0.0`1.0 )BMx̒l𒴂Accepted ƂȂ܂B
		amiSetConfidenceLevel(recognizer, 0.4f);
		// [h̐ݒ
		amiSetMode(recognizer, AMI_MODE_RECOGNITION | AMI_MODE_RESULT);
		// Updated Cxg̐ݒ(0 ResultUpdated Cxg͔܂)
		amiSetResultUpdatedInterval(recognizer, 0);
		// ^foCX̐ݒ(Pidora ̏ꍇ͓0AUSB 1 ƂȂ܂)
		// TvOg͕ύXł܂B
		amiSetDeviceId(recognizer, 1);

		// ͂̊Jn
		if (amiResume(recognizer)) {
			_tprintf(_T("INFO: resumed recording\n"));
		} else {
			_tprintf(_T("INFO: can't resume\n"));
		}

		// Xbh̊Jn
		start();

		// f[^̏
		while ((amiIsActive(recognizer) || amiIsRecognizing(recognizer)) && isAlive()) {
			if (kbhit() == 1) {
				printf("\n");
				break;
			}
			// 1 bԂ̑ҋ@
			amiSleep(100);
		}

		// ͂̒~
		amiPause(recognizer, /* cancel */ true, /* blocking */ true);
		_tprintf(_T("INFO: paused recording and decoded %d results\n"), resultCount_);
		
		while (command_ != NULL) {
			// 1 bԂ̑ҋ@
			amiSleep(100);
		}

		// Xbh̒~
		stop();

		// FGW̉
		amiUnloadRecognizer(recognizer);
		_tprintf(_T("INFO: unloaded recognizer\n"));

		// XCWrapper CȕI
		amiTerminate(recognizer);
		_tprintf(_T("INFO: terminated AmiVoice\n"));
		return 0;
	}

	void stop() {
		// XbhIvtÕZbg
		terminationRequested_ = true;

		// XbhȊҋ@
		if (AmiSample::Thread::getCurrentThreadId() != getThreadId()) {
			join(30 * 1000);
		}
	}

  private:
	// MpXbh
	void run() {
		// ARDrone IPAhX
		const char* address = "192.168.1.1";
		// ARDrone ̃|[g
		const int DRONE_COMMAND_PORT = 5556;

		// hostent ̎擾
		struct hostent* host = gethostbyname(address);
		if (host == NULL) {
			printf("ERROR: unknown host '%s'\n", address);
			return;
		}

		// ARDrone ɐڑ邽߂̏
		struct sockaddr_in droneAddr;
		droneAddr.sin_family = host->h_addrtype;
		droneAddr.sin_port = htons(DRONE_COMMAND_PORT);
		memcpy((char*)&droneAddr.sin_addr.s_addr, host->h_addr_list[0], host->h_length);

		struct sockaddr_in clientAddr;
		clientAddr.sin_family = AF_INET;
		clientAddr.sin_addr.s_addr = htonl(INADDR_ANY);
		clientAddr.sin_port = htons(0);

		int handle = socket(AF_INET, SOCK_DGRAM, 0);
		if (handle < 0) {
			printf("ERROR: cannot open socket \n");
			return;
		}

		if (bind(handle, (struct sockaddr*)&clientAddr, sizeof(clientAddr)) < 0) {
			printf("ERROR: cannot bind port\n");
			return;
		}
		
		// R}h̎s(Œ)
		int flags = 0;
		const char* startCommand[] = {"AT*CONFIG=1,\"general:navdata_demo\",\"TRUE\"\r",
									  "AT*FTRIM=2\r",
									  "AT*FTRIM=3\r",
									  "AT*FTRIM=4\r"};
		sendto(handle, startCommand[0], strlen(startCommand[0]) + 1, flags, (struct sockaddr*)&droneAddr, sizeof(droneAddr));
		AmiSample::Thread::sleep(40);
		sendto(handle, startCommand[1], strlen(startCommand[1]) + 1, flags, (struct sockaddr*)&droneAddr, sizeof(droneAddr));
		AmiSample::Thread::sleep(40);
		sendto(handle, startCommand[2], strlen(startCommand[2]) + 1, flags, (struct sockaddr*)&droneAddr, sizeof(droneAddr));
		AmiSample::Thread::sleep(40);
		sendto(handle, startCommand[3], strlen(startCommand[3]) + 1, flags, (struct sockaddr*)&droneAddr, sizeof(droneAddr));
		AmiSample::Thread::sleep(40);

		// R}hM[v
		unsigned int seq = 5;
		while (!terminationRequested_) {
			const char* command;
			mutex_->lock();
			if (command_ != NULL) {
				// R}hꍇ...
				// R}hMJE^̃fNg
				command_->count_--;
				if (command_->count_ < 0) {
					// zoOR}h̑M(5)
					command = makeCommand("AT*PCMD=%d,1,0,0,0,0\r", &seq);
					if (command_->count_ == -5) {
						// R}hMJE^ -5 ɂȂꍇ...
						// ̃R}h
						Command* nextCommand = (Command*)command_->next_;
						delete command_;
						command_ = nextCommand;
					}
				} else {
					// FʂɑΉR}h̍쐬
					command = makeCommand(command_->command_, &seq);
				}
			} else {
				// R}hȂꍇ...
				// zoOR}h̍쐬
				command = makeCommand("AT*PCMD=%d,1,0,0,0,0\r", &seq);
			}
			mutex_->unlock();

			// ARDrone ɃR}h𑗐M
			if (sendto(handle, command, strlen(command) + 1, flags, (struct sockaddr*)&droneAddr, sizeof(droneAddr)) < 0) {
				printf("ERROR: can not send data\n");
				close(handle);
				return;
			}
			AmiSample::Thread::sleep(40);
		}

		// IR}h̑M(Œ)
		for (int i = 0; i < 4; i++) {
			const char* endCommand = makeCommand("AT*REF=%d,290717696\r", &seq);
			sendto(handle, endCommand, strlen(endCommand) + 1, flags, (struct sockaddr*)&droneAddr, sizeof(droneAddr));
			AmiSample::Thread::sleep(40);
		}
		close(handle);
	}

	// ARDrone ̃R}h쐬
	const char* makeCommand(const char* command, unsigned int* seq) {
		static char result[1024];
		sprintf(result, command, *seq);
		*seq = *seq + 1;
		return result;
	}

	int kbhit(void) {
	    struct termios backupTermios;
	    struct termios newTermios;
	    int backupFl;

		// ݂̐ݒ擾
	    tcgetattr(STDIN_FILENO, &backupTermios);
		// t@C̃ANZX[hƃt@CԃtO擾
	    backupFl = fcntl(STDIN_FILENO, F_GETFL, 0);

		// VݒZbg
	    newTermios = backupTermios;
	    newTermios.c_lflag &= ~(ICANON | ECHO);
	    tcsetattr(STDIN_FILENO, TCSANOW, &newTermios);
	    fcntl(STDIN_FILENO, F_SETFL, backupFl | O_NONBLOCK);

		// 1擾
	    int ch = getchar();

		// ύXݒɖ߂
	    tcsetattr(STDIN_FILENO, TCSANOW, &backupTermios);
	    fcntl(STDIN_FILENO, F_SETFL, backupFl);

	    if (ch != EOF) {
	        ungetc(ch, stdin);
	        return 1;
	    }

	    return 0;
	}

	// FʎMpR[obN֐vg^Cv錾
	static void XCWRAPPER_API_CALL AmiVoice_ResultEventCallBack(AMI_RESULT* result, AMI_RESULT_EVENT_USERDATA userData) {
		ARDrone* ardrone = (ARDrone*)userData;
		if (result->state == AMI_RESULT_STATE_RESUMED) {
			_tprintf(_T("EVENT: RESUMED\n"));
		} else
		if (result->state == AMI_RESULT_STATE_PAUSED) {
			_tprintf(_T("EVENT: PAUSE\n"));
		} else
		if (result->state == AMI_RESULT_STATE_UTTERANCE_STARTED) {
			_tprintf(_T("EVENT: UTTERANCE_STARTED\n"));
		} else
		if (result->state == AMI_RESULT_STATE_UTTERANCE_ENDED) {
			_tprintf(_T("EVENT: UTTERANCE_ENDED\n"));
		} else
		if (result->state == AMI_RESULT_STATE_UTTERANCE_TOO_LONG) {
			_tprintf(_T("EVENT: UTTERANCE_TOO_LONG\n"));
		} else
		if (result->state == AMI_RESULT_STATE_UTTERANCE_TOO_LOUD) {
			_tprintf(_T("EVENT: UTTERANCE_TOO_LOUD\n"));
		} else
		if (result->state == AMI_RESULT_STATE_RESULT_CREATED) {
			_tprintf(_T("EVENT: RESULT_CREATED\n"));
		} else
		if (result->state == AMI_RESULT_STATE_RESULT_UPDATED) {
			_tprintf(_T("EVENT: RESULT_UPDATED: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
		} else
		if (result->state == AMI_RESULT_STATE_RESULT_ACCEPTED) {
			if (result->result != NULL && strlen(result->result) != 0) {
				const TCHAR* table[] = {_T("token"), _T("spoken"), _T("timetag"), _T("tag"), _T("ruleName"), _T("reserved"), _T("audioLogFileName")};
				TCHAR* resultInternal = new TCHAR[strlen(result->result) + 1];
				strcpy(resultInternal, result->result);

				TCHAR* index = resultInternal;
				TCHAR* results[7];
				memset(results, 0, sizeof(TCHAR*) * 7);

				// token, confidence, timetagAtagAruleName \
				for (int i = 0; i < 5; i++) {
					// 0x01 ŔFʂ𕪊
					TCHAR* foundIndex = _tcschr(index, (TCHAR)0x01);
					if (foundIndex == NULL) {
						break;
					}
					results[i] = index;
					*foundIndex = 0;
					index = foundIndex + 1;
					printf("%s : %s\n", table[i], (results[i] != NULL ? results[i]: "(none)"));
				}

				int tableIndex = -1;
				int count = 0;
				if (strcmp(results[3], "Takeoff") == 0) {
					tableIndex = 0;
					count = 10;
				} else
				if (strcmp(results[3], "Landing") == 0) {
					tableIndex = 1;
					count = 10;
				} else
				if (strcmp(results[3], "Forward") == 0) {
					tableIndex = 2;
					count = 20;
				} else
				if (strcmp(results[3], "Back") == 0) {
					tableIndex = 3;
					count = 20;
				} else
				if (strcmp(results[3], "Right") == 0) {
					tableIndex = 4;
					count = 20;
				} else
				if (strcmp(results[3], "Left") == 0) {
					tableIndex = 5;
					count = 20;
				} else
				if (strcmp(results[3], "RotateRight") == 0) {
					tableIndex = 6;
					count = 20;
				} else
				if (strcmp(results[3], "RotateLeft") == 0) {
					tableIndex = 7;
					count = 20;
				} else
				if (strcmp(results[3], "Up") == 0) {
					tableIndex = 8;
					count = 20;
				} else
				if (strcmp(results[3], "Down") == 0) {
					tableIndex = 9;
					count = 20;
				} else
				if (strcmp(results[3], "Emergency") == 0) {
					tableIndex = 10;
					count = 5;
				}
				if (strcmp(results[3], "Dance") == 0) {
					tableIndex = 11;
					count = 5;
				}

				ardrone->mutex_->lock();
				if (tableIndex >= 0) {
					Command* newCommand = new Command;
					newCommand->command_ = CommandTable[tableIndex];
					newCommand->count_ = count;
					newCommand->next_ = NULL;
					if (ardrone->command_ == NULL) {
						ardrone->command_ = newCommand;
					} else {
						Command* command = ardrone->command_;
						while (command->next_ != NULL) {
							command = (Command*)command->next_;
						}
						command->next_ = newCommand;
					}
				}
				ardrone->mutex_->unlock();

				delete resultInternal;
			}
			ardrone->resultCount_++;
		} else
		if (result->state == AMI_RESULT_STATE_RESULT_REJECTED) {
			_tprintf(_T("EVENT: RESULT_REJECTED: %s\n"), (result->result[0] != 0) ? result->result : _T("-"));
		}
	}

private:
	bool terminationRequested_;
	AmiSample::Mutex* mutex_;
	int resultCount_;
	struct Command {
		const char* command_;
		int count_;
		void* next_;
	};
	Command* command_;
	static const char* CommandTable[];
};

const char* ARDrone::CommandTable[] = {"AT*REF=%d,290718208\r",				// Takeoff
									   "AT*REF=%d,290717696\r",				// Landing
									   "AT*PCMD=%d,1,0,-1102263091,0,0\r",	// Forward
									   "AT*PCMD=%d,1,0,1045220557,0,0\r",	// Back
									   "AT*PCMD=%d,1,1045220557,0,0,0\r",	// Right
									   "AT*PCMD=%d,1,-1102263091,0,0,0\r",	// Left
									   "AT*PCMD=%d,1,0,0,0,1061997773\r",	// RotateRight
									   "AT*PCMD=%d,1,0,0,0,-1085485875\r",	// RotateLeft
									   "AT*PCMD=%d,1,0,0,1045220557,0\r",	// Up
									   "AT*PCMD=%d,1,0,0,-1102263091,0\r",	// Down
									   "AT*REF=%d,290717952\r",				// Emergency
									   "AT*ANIM=%d,12,5000\r"};				// Dance

// C֐
int main(int argc, TCHAR** argv) {
	// P[̐ݒ
	setlocale(LC_ALL, "");

	ARDrone ardrone;
	ardrone.go(argc, argv);

	// vȌI
	return 0;
}
